/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.service.UnixServiceHandler;
import com.install4j.runtime.launcher.util.ErrorHandler;
import java.util.ArrayList;

public class Launcher {
    public static final boolean JAVA_1_6 = System.getProperty("java.version", "").startsWith("1.6");
    private static String[] originalArgs;

    public static void main(String[] args) {
        block10: {
            LauncherHelper.INSTANCE.initIntegration();
            args = LauncherHelper.INSTANCE.initVariables(Launcher.class, args);
            try {
                SplashScreenConfig splashScreenConfig;
                ArgumentStack argStack = new ArgumentStack(args);
                String method = argStack.popString();
                if (method.equals("stop")) {
                    UnixServiceHandler.INSTANCE.setStop();
                    break block10;
                }
                if (method.equals("status")) {
                    UnixServiceHandler.INSTANCE.reportStatus();
                    break block10;
                }
                String className = argStack.popString();
                boolean isGuiApplication = argStack.popBoolean();
                ErrorHandler.setIsGuiApplication(isGuiApplication);
                boolean isEvaluation = argStack.popBoolean();
                String stdErrFile = argStack.popString();
                String stdOutFile = argStack.popString();
                boolean failOnMainMethodException = argStack.popBoolean();
                try {
                    splashScreenConfig = new SplashScreenConfig().init(argStack);
                    originalArgs = Launcher.getArgumentArray(argStack, Boolean.getBoolean("i4j.vpt"));
                }
                catch (Exception e) {
                    originalArgs = new String[0];
                    splashScreenConfig = new SplashScreenConfig();
                }
                SplashEngine.setJavaSplashScreenConfig(true, splashScreenConfig);
                if (method.equals("launch")) {
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("start")) {
                    if (isEvaluation) {
                        System.out.println("This daemon was created with an evaluation version of install4j.");
                    }
                    UnixServiceHandler.INSTANCE.setStart();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                }
            }
            catch (Exception e) {
                ErrorHandler.reportError(e);
                System.exit(1);
            }
        }
    }

    static String[] getArgumentArray(ArgumentStack argStack, boolean removeVmPassThrough) {
        int numArgs = argStack.popInt();
        if (numArgs == -1) {
            numArgs = argStack.size();
        }
        return Launcher.getArgumentArray(argStack, numArgs, removeVmPassThrough);
    }

    static String[] getArgumentArray(ArgumentStack argStack, int numArgs, boolean removeVmPassThrough) {
        boolean removeJvmParameter = LauncherEngine.getBooleanProperty(169);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < numArgs; ++i) {
            boolean remove;
            String singleArg = argStack.popString();
            boolean bl = remove = removeVmPassThrough && singleArg.startsWith("-J") || removeJvmParameter && singleArg.startsWith("-jvm=");
            if (remove) continue;
            ret.add(singleArg);
        }
        return ret.toArray(new String[0]);
    }

    public static boolean isService() {
        return UnixServiceHandler.INSTANCE.isService() || WinLauncher.isService();
    }

    private Launcher() {
    }

    public static String[] appendOriginalArgs(String[] params) {
        if (originalArgs != null) {
            String[] ret = new String[params.length + originalArgs.length];
            System.arraycopy(params, 0, ret, 0, params.length);
            System.arraycopy(originalArgs, 0, ret, params.length, originalArgs.length);
            return ret;
        }
        return params;
    }

    static void setOriginalArgs(String[] originalArgs) {
        Launcher.originalArgs = originalArgs;
    }
}

