/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherReplacementCallback;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.integration.LauncherIntegration;
import com.install4j.runtime.launcher.service.UnixServiceHandler;
import com.install4j.runtime.launcher.util.ErrorHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.launcher.util.SingleInstance;
import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Properties;

public class UnixLauncher {
    public static final String PROPNAME_EXECUTABLE_PATH = "executablePath";
    private static boolean isGuiApplication;
    private static boolean failOnMainMethodException;
    private static String[] originalArgs;
    private static String stdErrFile;
    private static String stdOutFile;
    private static String className;

    public static void start(String className, String method, String configId, Properties properties, String[] args) {
        UnixLauncher.setVMWareWorkaroundParameter();
        if (System.getProperty("java.net.useSystemProxies") == null) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        LauncherIntegration.init();
        args = LauncherVariables.init(UnixLauncher.class, args);
        ArgumentStack argStack = new ArgumentStack(args);
        if (method == null) {
            method = argStack.popString();
        }
        try {
            System.setProperty("install4j.jvmDir", System.getProperty("java.home"));
            File runtimeDir = ResourceHelper.getRuntimeDir();
            String moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                String relativePath = properties.getProperty(PROPNAME_EXECUTABLE_PATH, "unknown");
                moduleName = FileUtil.getCanonicalPath(new File(new File(runtimeDir, ".."), relativePath));
                System.setProperty("exe4j.moduleName", moduleName);
            }
            LauncherEngine.setProperties(properties);
            UnixLauncher.doStart(className, method, UnixLauncher.isInstaller(configId), argStack);
        }
        catch (Exception e) {
            ErrorHandler.reportError(e);
            System.exit(1);
        }
    }

    static void doStart(String className, String method, boolean installer, ArgumentStack argStack) {
        if (method.equals("stop")) {
            UnixServiceHandler.INSTANCE.setStop();
        } else if (method.equals("status")) {
            UnixServiceHandler.INSTANCE.reportStatus();
        } else {
            File exeBaseDir = new File(System.getProperty("exe4j.moduleName")).getParentFile();
            File installerTempDir = installer ? ResourceHelper.getRuntimeDir() : null;
            stdErrFile = UnixLauncher.getRedirectionFileName(exeBaseDir, installerTempDir, 102, 103);
            stdOutFile = UnixLauncher.getRedirectionFileName(exeBaseDir, installerTempDir, 104, 105);
            UnixLauncher.prepareLaunch(argStack, method, installer, LauncherEngine.getBooleanProperty(125));
            LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
        }
    }

    public static void main(String[] args) {
        LauncherIntegration.init();
        args = LauncherVariables.init(UnixLauncher.class, args);
        try {
            ArgumentStack argStack = new ArgumentStack(args);
            String method = argStack.popString();
            if (method.equals("stop")) {
                UnixServiceHandler.INSTANCE.setStop();
            } else if (method.equals("status")) {
                UnixServiceHandler.INSTANCE.reportStatus();
            } else {
                String configId = argStack.popString();
                LauncherEngine.setProperties(UnixLauncher.readProperties(configId));
                stdErrFile = argStack.popString();
                stdOutFile = argStack.popString();
                className = argStack.popString();
                UnixLauncher.prepareLaunch(argStack, method, UnixLauncher.isInstaller(configId), Boolean.getBoolean("i4j.vpt"));
                LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError(e);
            System.exit(1);
        }
    }

    private static void prepareLaunch(ArgumentStack argStack, String method, boolean isInstaller, boolean removeVmPassThrough) {
        if (LauncherUtil.isMacOS() && !InstallerUtil.getInstallerFile(Common.getMacLibraryFilename(0)).isFile()) {
            System.setProperty("install4j.noNativeDialogs", "true");
        }
        isGuiApplication = LauncherEngine.getBooleanProperty(162);
        ErrorHandler.setIsGuiApplication(isGuiApplication);
        failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
        originalArgs = Launcher.getArgumentArray(argStack, argStack.size(), removeVmPassThrough);
        Launcher.setOriginalArgs(originalArgs);
        SplashEngine.setJavaSplashScreenConfig(LauncherEngine.getBooleanProperty(108), new SplashScreenConfig().initFromLauncherEngine());
        if (method.equals("launch")) {
            UnixLauncher.checkSingleInstance(isInstaller, originalArgs);
            UnixLauncher.checkWarning();
        } else if (method.equals("start")) {
            UnixServiceHandler.INSTANCE.setStart();
            if (LauncherEngine.getBooleanProperty(10011)) {
                UnixLauncher.checkSingleInstance(isInstaller, originalArgs);
            }
        } else if (method.equals("run")) {
            UnixLauncher.checkSingleInstance(isInstaller, originalArgs);
            UnixLauncher.checkWarning();
            stdErrFile = "";
            stdOutFile = "";
        } else if (method.equals("run-redirect")) {
            UnixLauncher.checkSingleInstance(isInstaller, originalArgs);
            UnixLauncher.checkWarning();
        }
    }

    private static void checkSingleInstance(boolean isInstaller, String[] originalArgs) {
        String moduleName;
        boolean restart;
        boolean bl = restart = originalArgs.length >= 1 && ("__i4j_lang_restart".equals(originalArgs[0]) || "__i4j_auth_restart".equals(originalArgs[0]));
        if (!restart && LauncherEngine.getBooleanProperty(10005) && (moduleName = System.getProperty("exe4j.moduleName")) != null) {
            SingleInstance.checkForCurrentLauncher(new File(moduleName), LauncherEngine.getBooleanProperty(158), isInstaller ? null : originalArgs);
        }
    }

    private static void checkWarning() {
        if (LauncherEngine.getBooleanProperty(148)) {
            System.out.println("This launcher was created with an evaluation version of install4j.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties readProperties(String configId) {
        if (UnixLauncher.isInstaller(configId)) {
            Properties properties2 = new Properties();
            properties2.setProperty(String.valueOf(162), String.valueOf(1));
            properties2.setProperty(String.valueOf(10005), String.valueOf(1));
            return properties2;
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(InstallerUtil.getInstallerFile(configId + ".lprop").toPath(), new OpenOption[0]));){
            Properties properties3 = new Properties();
            properties3.load(in);
            Properties properties = LauncherUtil.replaceVariables(properties3);
            return properties;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Properties();
        }
    }

    private static boolean isInstaller(String configId) {
        return configId.equals("0");
    }

    static String getRedirectionFileName(File exeBaseDir, File installerTempDir, int propertyRedirect, int propertyFile) {
        String redirectionFile = "";
        if (LauncherEngine.getBooleanProperty(propertyRedirect)) {
            String file = LauncherVariables.replaceVariables(LauncherEngine.getProperty(propertyFile), new LauncherReplacementCallback(exeBaseDir, installerTempDir));
            file = file.replace("//", "/");
            if (!(file = LauncherEngine.replaceUserHome(file)).startsWith(File.separator)) {
                redirectionFile = exeBaseDir.getAbsolutePath() + File.separator;
            }
            redirectionFile = redirectionFile + file;
        }
        return redirectionFile;
    }

    private static boolean isLinuxOnVMWare() {
        block4: {
            if (LauncherUtil.isLinux()) {
                try {
                    File file = new File("/proc/scsi/scsi");
                    if (file.isFile()) {
                        String content = FileUtil.readTextFile(file, "UTF-8").toLowerCase(Locale.ROOT);
                        return content.contains("vmware");
                    }
                }
                catch (Exception e) {
                    if (!Boolean.getBoolean("install4j.debugVMWare")) break block4;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static void setVMWareWorkaroundParameter() {
        if (Boolean.getBoolean("install4j.checkVMWare") && System.getProperty("sun.java2d.opengl") == null && UnixLauncher.isLinuxOnVMWare()) {
            System.setProperty("sun.java2d.opengl", "true");
        }
    }
}

